<?php
header("Content-Type: application/json");
require 'db.php';

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    // Fetch all records
    $sql = "SELECT * FROM money_flow ORDER BY created_at DESC";
    $result = $conn->query($sql);

    $data = [];
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
    }
    echo json_encode($data);

} elseif ($method === 'POST') {
    // Add new record
    $input = json_decode(file_get_contents('php://input'), true);

    $type = $input['type'];
    $amount = $input['amount'];
    $description = $input['description'];
    // Optional: Add date support if needed, currently using CURRENT_TIMESTAMP
    $date = isset($input['date']) ? $input['date'] : date('Y-m-d H:i:s');

    // If table has a date column, use it. Otherwise rely on created_at
    // Assuming we might want to backdate transactions based on user request "date stamp"
    // For now, let's stick to the existing schema which has created_at. 
    // If we need custom dates, we might need to alter the table or just use created_at.
    // Let's assume created_at is fine for now, or we can manually set it if the DB allows.

    $stmt = $conn->prepare("INSERT INTO money_flow (type, amount, description, created_at) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("sdss", $type, $amount, $description, $date);

    if ($stmt->execute()) {
        echo json_encode(["status" => "success"]);
    } else {
        echo json_encode(["status" => "error", "message" => $stmt->error]);
    }
    $stmt->close();
}

$conn->close();
?>